<?php

namespace VM\ApiBundle\Controller;

use Doctrine\DBAL\LockMode;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyDistributionSales;
use VM\ApiBundle\Entity\DistributionSales;
use VM\ApiBundle\Entity\MarketSegment;
use VM\ApiBundle\Exceptions\ApiException;


class DistributionSalesController extends AbstractController
{
    /**
     * @View()
     */
    public function saveAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();
            $distributionSalesList = $data['_list'];
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $MarketSegment = $this->getApiGetter()->getMarketSegmentForUser($User);

            if($MarketSegment->getDistributionSales()->isEmpty())
            {
                return true;
            }

            $distribution = array();
            $sum = 0;
            foreach($distributionSalesList as $distributionSalesData)
            {
                $distribution[$distributionSalesData['d']['id']] = $distributionSalesData['value'];
                $sum += $distributionSalesData['value'];
            }
            if($sum != 100)
            {
                throw new ApiException('Sum percent must by 100');
            }

            /** @var CompanyDistributionSales $CompanyDistributionSales */
            foreach($Company->getCompanyDistributionSales() as $CompanyDistributionSales)
            {
                if(isset($distribution[$CompanyDistributionSales->getDistributionSalesId()]))
                {
                    $CompanyDistributionSales->setValue($distribution[$CompanyDistributionSales->getDistributionSalesId()]);
                    unset($distribution[$CompanyDistributionSales->getDistributionSalesId()]);
                    $this->getDoctrine()->getManager()->persist($CompanyDistributionSales);
                }
            }

            if(!empty($distribution))
            {
                foreach($distribution as $id => $value)
                {
                    $CompanyDistributionSales = new CompanyDistributionSales();
                    $CompanyDistributionSales->setValue($value);
                    $CompanyDistributionSales->setCompany($Company);
                    $CompanyDistributionSales->setDistributionSales($this->getApiGetter()->getDistributionSales($id));

                    $this->getDoctrine()->getManager()->persist($CompanyDistributionSales);
                }
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();

            return true;
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @View(serializerGroups={"distributionSalesList"})
     */
    public function getAction()
    {
        $return = array();
        $User = $this->getUser();
        /** @var MarketSegment $MarketSegment */
        $MarketSegment = $User->getGroup()->getUser()->getMarketSegment();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

        /** @var DistributionSales $DistributionSales */
        foreach($MarketSegment->getDistributionSales() as $DistributionSales)
        {
            $value = 0;
            /** @var CompanyDistributionSales $CompanyDistributionSales */
            foreach($Company->getCompanyDistributionSales() as $CompanyDistributionSales)
            {
                if($CompanyDistributionSales->getDistributionSalesId() == $DistributionSales->getId())
                {
                    $value = $CompanyDistributionSales->getValue();
                }
            }
            $return[] = array('d'=>$DistributionSales,'value'=>$value);
        }

        return $return;
    }
}